// ActionScript file
package  {
	import flash.display.Shape;
	import flash.display.Sprite;
	//import fl.events.SliderEvent;
	//import fl.controls.Slider;

	public class CircularScene extends Sprite{
		
		//constants
		private const xCenter:int=700;
		private const yCenter:int=350;
		private const numberOfRadiuses:int=12;
		private const lineAngle:Number = (Math.PI*2)/numberOfRadiuses;
		private const circleRadiuses:Array = new Array(100,200,300,400,500);

	public function CircularScene(inputradiuses:Array=null){
		
		var radiuses:Array;
		//this enables this class to accept radiuses from caller
		if(inputradiuses==null)
			radiuses = circleRadiuses;
		else
			radiuses = inputradiuses;
		var numBackgroundCircle:int = radiuses.length;
		var i:int=0;
		// drawing circle 
		var mycircle:Shape = new Shape( ); 
		mycircle.graphics.lineStyle(1,0x00000000,100);
		for(i=0;i<numBackgroundCircle;i++)
		{
			mycircle.graphics.drawCircle( 0,0, radiuses[i]);
			// repositioning shape
			mycircle.x = xCenter;                                 
			mycircle.y = yCenter;
			// adding displayobject to the display list
			addChild( mycircle );
		}
		
		var biggestRadius:int = radiuses[numBackgroundCircle-1];
		
		var myLine:Shape = new Shape( );
		//horizon line
		myLine.graphics.lineStyle(3,0x00000000,100);
		myLine.graphics.moveTo(xCenter, yCenter); 
		myLine.graphics.lineTo(xCenter+biggestRadius, yCenter);
		addChild(myLine);
		
		//other lines	
		myLine.graphics.lineStyle(1,0x00000000,100);
		for (var j:int=1; j<numberOfRadiuses; j++)
		{
			myLine.graphics.moveTo(xCenter, yCenter); 
			myLine.graphics.lineTo(xCenter+biggestRadius*Math.cos(j*lineAngle), yCenter+biggestRadius*Math.sin(j*lineAngle));
			addChild(myLine);
		}
		
	}
		
	
	}//class
}//package